import { Dimensions, StyleSheet } from "react-native";
const { width } = Dimensions.get("screen");
import dpr from "../Utilities/CustomStyleAttribute/dpr";
import { I18nManager } from "react-native";

export const trackOrderStyle = StyleSheet.create({
    login: {
        textDecorationLine: "underline",
        textDecorationColor: "#2C2C2C",
        color: "#2C2C2C",
    },
    orderRocketSvg: {
        display: "flex",
        alignItems: "center",
        marginTop: dpr(42),
        marginBottom: dpr(31)
    },
    orderHeader: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        color: "#2C2C2C",
        textAlign: "center",
    },
    orderDesc: {
        fontFamily: "Roboto_500Medium",
        marginTop: dpr(12),
        fontSize: dpr(14),
        color: "#898989",
        textAlign: "center",
    },
    textInput: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        height: dpr(50),
        paddingHorizontal: dpr(15),
        marginTop: dpr(22),
        marginBottom: dpr(15),
        borderWidth: dpr(1),
        borderColor: "#BCBCBC",
        borderRadius: dpr(6),
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    trackOrderButton: {
        backgroundColor: "#FCCA19",

        borderRadius: dpr(6),
    },
    trackOrderButtonText: {
        color: "#2C2C2C",
        fontFamily: "DMSans_700Bold",
        paddingVertical: dpr(17),
        fontSize: dpr(18),
        textAlign: "center",
    },
    moreDetailsContainer: {
        flexDirection: "row",
        flexWrap: 'wrap',
        alignItems: "baseline",
        justifyContent: 'center',
        marginBottom: dpr(20),
        width: dpr('wf') - dpr(40),
    },
    moreDetailsText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(13),
        color: "#898989",
        marginTop: dpr(10),
    },
    hrLine: {
        borderBottomWidth: 1,
        borderColor: "#DFDFDF",
    },
    topPosition: {
        marginVertical: dpr(20),
    },
    topText1: {
        textAlign: "center",
        marginTop: dpr(15),
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        color: "#2C2C2C",
    },
    topText2: {
        textAlign: "center",
        marginTop: dpr(6),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#009651",
    },
    deliverySubCont: {
        borderLeftWidth: 1,
        borderColor: "#B1B1B1"
    },
    deliveryContainer: {
        marginTop: dpr(15)
    },
    changeInfo: {
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 12,
        },
        shadowOpacity: 0.6,
        elevation: 24,
        backgroundColor: "#fff",
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        padding: dpr(13),
        width: width,
    },
    cancel: {
        width: (width - dpr(20, "w") - dpr(30, "w")) / 2,
        height: dpr(45),
        textAlign: "center",
        textAlignVertical: "center",
        fontFamily: "DMSans_700Bold",
        color: "#9B9B9B",
        fontSize: dpr(16),
    },
    saveAddressCont: {
        width: (width - dpr(50)) / 2,
        height: dpr(45),
        backgroundColor: "#FCCA19",
        justifyContent: "center",
        alignItems: "center",
        borderRadius: dpr(6),
    },
    saveAddressBtn: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        lineHeight: dpr(21),
        color: "#2C2C2C",
    },
});
